import pandas as pd
from src.utilities import get_equivalent_waves_up_to

class Experiment_Settings():
    """This class simply holds the key details needed to arrange 
    an experiment"""
    def __init__(
        self,
        test_dataset:pd.DataFrame,
        test_dataset_name:str,
        train_dataset:pd.DataFrame,
        train_dataset_name:str,
        test_waves:list = [0,1,2,3,4,5,6,7,8,9,10],
        mode:callable=get_equivalent_waves_up_to,
        mode_name:str="Equivalent In Lifecycle",
        max_train_size = 5
    ):
        self.test_dataset = test_dataset
        self.test_dataset_name = test_dataset_name
        self.train_dataset = train_dataset
        self.train_dataset_name = train_dataset_name
        self.test_waves = test_waves
        self.mode = mode
        self.mode_name = mode_name
        self.max_train_size = max_train_size